<?php include 'header.php'; ?>
<div id="dsn-scrollbar">

    <!-- ========== 3D Inspection Section ========== -->
    <div id="page_wrapper" class="wrapper">

        <!-- Service Intro -->
        <div class="section-margin text-center">
            <div class="container">
                <h3 class="title text-upper mb-30">3D Inspection</h3>
                <p class="max-w750">
                    Ensure unmatched accuracy and quality with Zeno 3D’s advanced <strong>3D Inspection Solutions</strong>. 
                    Using cutting-edge blue light and laser scanning technologies, our team captures highly precise 3D measurements of your components, 
                    from the simplest parts to the most complex geometries. With accuracy up to <strong>±0.01 mm</strong>, we ensure that every critical dimension is analyzed thoroughly. 
                    Our process provides deep insights into deviations, surface imperfections, and assembly fit, empowering manufacturers to maintain the highest standards of precision and reliability in their products.
                </p>
            </div>
        </div>

        <!-- Features Gallery -->
        <div class="container p-relative section-margin over-hidden">
            <h4 class="title text-upper mb-30">Core Features of 3D Inspection</h4>
            <div class="gallery-portfolio">

                <!-- Precision 3D Inspection -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_inspection/Precision 3D Inspection.jpg"
                    data-fancybox="_1" data-caption="3D Inspection – High Accuracy">
                    <img src="assets/img/Zeno_All_img/3d_inspection/Precision 3D Inspection.jpg" alt="3D Inspection">
                    <div class="cap">
                        <span>Precision 3D Inspection</span>
                    </div>
                </a>

                <!-- CAD vs Part Analysis -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_inspection/CAD vs Part Analysis.jpeg"
                    data-fancybox="_1" data-caption="CAD vs Physical Part Analysis">
                    <img src="assets/img/Zeno_All_img/3d_inspection/CAD vs Part Analysis.jpeg" alt="CAD vs Part Analysis">
                    <div class="cap">
                        <span>CAD vs Part Analysis</span>
                    </div>
                </a>

                <!-- GD&T & QC Reports -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_inspection/GD&T and QC Reporting.jpg"
                    data-fancybox="_1" data-caption="GD&T and QC Reporting">
                    <img src="assets/img/Zeno_All_img/3d_inspection/GD&T & QC Reports.jpg" alt="GD&T Reporting">
                    <div class="cap">
                        <span>GD&T & QC Reports</span>
                    </div>
                </a>

                <!-- Industry Applications -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_inspection/Industry Applications.jpg"
                    data-fancybox="_1" data-caption="Applications in Automotive | Aerospace | Medical | Manufacturing">
                    <img src="assets/img/Zeno_All_img/3d_inspection/Industry Applications.jpg" alt="Industry Applications">
                    <div class="cap">
                        <span>Industry Applications</span>
                    </div>
                </a>

            </div>
        </div>

        <!-- Benefits Section -->
        <div class="section-margin text-center">
            <div class="container">
                <h4 class="title text-upper mb-50">Why Choose Zeno 3D for 3D Inspection?</h4>
                <div class="benefits-grid">

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-ruler-combined"></i></div>
                        <h5>Ultra-Precise Measurements</h5>
                        <p>
                            Every critical component is measured with extreme precision, down to ±0.01 mm. 
                            Our meticulous scanning process ensures that even microscopic deviations are detected, 
                            enabling manufacturers to produce parts that fit perfectly in assemblies, maintain performance standards, and reduce waste.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-search"></i></div>
                        <h5>Detailed Deviation Analysis</h5>
                        <p>
                            We provide a full CAD vs part comparison, along with GD&T reporting, highlighting any deviations from specifications. 
                            This allows engineers to quickly identify areas requiring adjustment, ensure regulatory compliance, and improve overall product quality.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-stopwatch"></i></div>
                        <h5>Fast Reporting</h5>
                        <p>
                            Inspection results are delivered rapidly, typically within 48 hours. 
                            Fast reporting allows design and production teams to take immediate corrective actions, 
                            reduce downtime, and meet tight project timelines without compromising on accuracy.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-industry"></i></div>
                        <h5>Trusted Across Industries</h5>
                        <p>
                            Our 3D inspection services are relied upon by leaders in automotive, aerospace, medical, and industrial manufacturing sectors worldwide. 
                            Zeno 3D ensures consistent quality and performance, making us a trusted partner for companies requiring high-precision inspection services.
                        </p>
                    </div>

                </div>
            </div>
        </div>

        <!-- Detailed Info / Project Info -->
        <div class="project-info section-margin">
            <div class="container">
                <div class="section-title dsn-fill mb-70 d-flex flex-column">
                    <span class="sub-heading mb-5">Our Service</span>
                    <h2 class="title">3D Inspection <br> Ensuring Precision & Quality</h2>
                </div>

                <p>
                    At <strong>Zeno 3D</strong>, our <strong>3D Inspection</strong> services provide a comprehensive end-to-end solution for verifying, validating, and improving component dimensions and quality. 
                    By leveraging advanced 3D scanning technologies, we capture every detail of physical parts and generate highly accurate digital models. 
                    These models allow precise CAD comparisons, detailed GD&T reporting, and informed decision-making for quality control processes.
                </p>

                <p>
                    Our inspection services are ideal for <strong>automotive, aerospace, industrial, and medical applications</strong>. 
                    Companies can ensure strict compliance with industry standards, reduce manufacturing errors, and optimize production efficiency. 
                    Detailed deviation reports provide engineers and designers with actionable insights, enabling proactive adjustments and continuous product improvement.
                </p>

                <p>
                    Zeno 3D also provides seamless integration with prototyping, production, and reverse engineering workflows. 
                    This ensures that inspection results are immediately actionable, helping teams identify potential issues early, save costs, and streamline the overall product development cycle. 
                    With our services, manufacturers can confidently deliver high-quality products that meet exact specifications and exceed customer expectations.
                </p>

            </div>
        </div>

    </div>

</div>
<?php include 'footer.php'; ?>

<!-- ===== CSS ===== -->
<style>
.benefits-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));    
    gap: 35px;
    margin-top: 40px;
}
.benefit-card {
    background: #fff;
    border-radius: 16px;
    padding: 35px 25px;
    text-align: center;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: transform 0.35s ease, box-shadow 0.35s ease;
    position: relative;
    overflow: hidden;
    cursor: pointer;
}
.benefit-card:hover {transform: translateY(-12px);box-shadow:0 18px 45px rgba(0,0,0,0.2);}
.benefit-card .icon {width:70px;height:70px;border-radius:50%;background:linear-gradient(135deg,#007BFF,#00A86B);display:flex;align-items:center;justify-content:center;margin:0 auto 18px;font-size:30px;color:#fff;transition:transform 0.35s ease, box-shadow 0.35s ease, background 0.35s ease;}
.benefit-card:hover .icon {transform: scale(1.25) rotate(10deg);box-shadow:0 8px 20px rgba(0,171,85,0.5);background:linear-gradient(135deg,#00A86B,#007BFF);}
.benefit-card h5 {font-size:20px;font-weight:700;color:#222;margin-bottom:12px;}
.benefit-card p {font-size:15px;color:#666;line-height:1.7;}
.benefit-card::after {content:"";position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(0,171,85,0.05);border-radius:16px;opacity:0;transition:opacity 0.35s ease;}
.benefit-card:hover::after {opacity:1;}
</style>
