<?php include 'header.php'; ?>
<div id="dsn-scrollbar">

    <!-- ========== 3D Printing Section ========== -->
    <div id="page_wrapper" class="wrapper">

        <!-- Service Intro -->
        <div class="section-margin text-center">
            <div class="container">
                <h3 class="title text-upper mb-30">3D Printing</h3>
                <p class="max-w750">
                    Bring your concepts to life with <strong>Zeno 3D’s high-precision 3D Printing Solutions</strong>. 
                    Our services enable innovators, engineers, and designers to transform abstract ideas into tangible, high-quality models. 
                    From rapid prototyping to fully functional end-use parts, we provide accurate, consistent, and reliable prints using state-of-the-art additive manufacturing technologies. 
                    Each project is handled with meticulous care, ensuring that every design is faithfully translated into a physical component that preserves dimensional accuracy, surface finish, and overall quality. 
                    Whether it’s for testing, validation, or final production, Zeno 3D ensures that every printed object meets the highest standards of excellence.
                </p>
            </div>
        </div>

        <!-- Features Gallery -->
        <div class="container p-relative section-margin over-hidden">
            <h4 class="title text-upper mb-30">Core Features of 3D Printing</h4>
            <div class="gallery-portfolio">

                <!-- High-Precision Printing -->
                <!-- <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_printing/3D Printing_s_P.jpg"
                    data-fancybox="_1" data-caption="High-Precision 3D Printing">
                    <img src="assets/img/Zeno_All_img/3D Printing_s_P.jpg" alt="High-Precision 3D Printing">
                    <div class="cap">
                        <span>High-Precision Printing</span>
                    </div>
                </a> -->

                <!-- Rapid Prototyping -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_printing/Rapid Prototyping.jpeg"
                    data-fancybox="_1" data-caption="Rapid Prototyping Services">
                    <img src="assets/img/Zeno_All_img/3d_printing/Rapid Prototyping.jpeg" alt="Rapid Prototyping">
                    <div class="cap">
                        <span>Rapid Prototyping</span>
                    </div>
                </a>

                <!-- Functional Parts -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_printing/Functional Parts.jpeg"
                    data-fancybox="_1" data-caption="Durable & Functional End-Use Parts">
                    <img src="assets/img/Zeno_All_img/3d_printing/Functional Parts.jpeg" alt="Functional Parts">
                    <div class="cap">
                        <span>Functional Parts</span>
                    </div>
                </a>

                <!-- Industry Applications -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3d_printing/Industry Applications.jpg"
                    data-fancybox="_1" data-caption="Applications in Automotive | Medical | Engineering">
                    <img src="assets/img/Zeno_All_img/3d_printing/Industry Applications.jpg" alt="Industry Applications">
                    <div class="cap">
                        <span>Industry Applications</span>
                    </div>
                </a>

            </div>
        </div>

        <!-- Benefits Section -->
        <div class="section-margin text-center">
            <div class="container">
                <h4 class="title text-upper mb-50">Why Choose Zeno 3D for 3D Printing?</h4>
                <div class="benefits-grid">

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-cube"></i></div>
                        <h5>High-Precision Printing</h5>
                        <p>
                            At Zeno 3D, every component is produced with exceptional precision, ensuring that even the most intricate and complex geometries are accurately reproduced. 
                            Our printing technology maintains tight tolerances for both prototype and production parts, guaranteeing consistency, repeatability, and superior quality across every project. 
                            The end result is a flawlessly crafted part that faithfully reflects the original design intent, whether for testing, functional use, or display.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-stopwatch"></i></div>
                        <h5>Rapid Prototyping</h5>
                        <p>
                            Our rapid prototyping services allow for fast, iterative design testing and development. 
                            With quick turnaround times, designers and engineers can evaluate concepts, make refinements, and optimize functionality without delays. 
                            This acceleration in the product development cycle reduces overall time-to-market, enabling teams to respond swiftly to new challenges and opportunities while maintaining high standards of accuracy and performance.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-cogs"></i></div>
                        <h5>Functional End-Use Parts</h5>
                        <p>
                            Zeno 3D doesn’t just create prototypes—we deliver durable, fully functional parts suitable for real-world applications. 
                            From mechanical components and complex assemblies to intricate functional devices, our 3D printing technology ensures strength, reliability, and usability. 
                            Each part undergoes rigorous testing to confirm that it meets design specifications and functional requirements, making it a seamless solution for production-ready projects.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-industry"></i></div>
                        <h5>Industry Applications</h5>
                        <p>
                            Our 3D printing solutions are trusted by a variety of industries including automotive, aerospace, medical, and heavy industrial sectors. 
                            By seamlessly integrating into engineering workflows and manufacturing processes, our services provide tailored solutions that enhance efficiency, accuracy, and innovation. 
                            Every printed component is engineered to meet stringent quality standards, ensuring smooth adoption in high-performance, mission-critical applications.
                        </p>
                    </div>

                </div>
            </div>
        </div>

        <!-- Detailed Info / Project Info -->
        <div class="project-info section-margin">
            <div class="container">
                <div class="section-title dsn-fill mb-70 d-flex flex-column">
                    <span class="sub-heading mb-5">Our Service</span>
                    <h2 class="title">3D Printing <br> Custom Solutions for Every Project</h2>
                </div>

                <p>
                    At <strong>Zeno 3D</strong>, our <strong>3D Printing</strong> services provide highly customized solutions designed to bring your designs to life with unmatched precision. 
                    Leveraging the latest advancements in additive manufacturing, we produce components that are accurate, reliable, and visually impressive. 
                    Every project—from concept models and early-stage prototypes to production-ready parts—is handled with attention to detail, ensuring your ideas are fully realized in the physical world.
                </p>

                <p>
                    Our expertise spans multiple industries including <strong>automotive, aerospace, industrial machinery, and custom equipment manufacturing</strong>. 
                    We ensure that each printed component adheres to stringent standards for accuracy, surface finish, strength, and functionality. 
                    By integrating our services into your development and manufacturing workflows, you can reduce time-to-market, minimize errors, and enhance overall product quality.
                </p>

                <p>
                    From rapid prototyping to functional end-use components, Zeno 3D provides a seamless workflow that aligns perfectly with your CAD designs and production processes. 
                    Each stage—from printing to post-processing, inspection, and quality validation—is carefully managed to ensure every part performs flawlessly in real-world applications. 
                    Our approach guarantees that your designs are not only printed but optimized for maximum efficiency, durability, and usability in their intended environment.
                </p>

            </div>
        </div>

    </div>

</div>
<?php include 'footer.php'; ?>

<!-- ===== CSS ===== -->
<style>
.benefits-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 35px;
    margin-top: 40px;
}
.benefit-card {
    background: #fff;
    border-radius: 16px;
    padding: 35px 25px;
    text-align: center;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: transform 0.35s ease, box-shadow 0.35s ease;
    position: relative;
    overflow: hidden;
    cursor: pointer;
}
.benefit-card:hover {transform: translateY(-12px);box-shadow:0 18px 45px rgba(0,0,0,0.2);}
.benefit-card .icon {width:70px;height:70px;border-radius:50%;background:linear-gradient(135deg,#007BFF,#00A86B);display:flex;align-items:center;justify-content:center;margin:0 auto 18px;font-size:30px;color:#fff;transition:transform 0.35s ease, box-shadow 0.35s ease, background 0.35s ease;}
.benefit-card:hover .icon {transform: scale(1.25) rotate(10deg);box-shadow:0 8px 20px rgba(0,171,85,0.5);background:linear-gradient(135deg,#00A86B,#007BFF);}
.benefit-card h5 {font-size:20px;font-weight:700;color:#222;margin-bottom:12px;}
.benefit-card p {font-size:15px;color:#666;line-height:1.7;}
.benefit-card::after {content:"";position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(0,171,85,0.05);border-radius:16px;opacity:0;transition:opacity 0.35s ease;}
.benefit-card:hover::after {opacity:1;}
</style>
