<?php include 'header.php'; ?>
<div id="dsn-scrollbar">

    <!-- ========== All Type Parts Scanning Section ========== -->
    <div id="page_wrapper" class="wrapper">

        <!-- Service Intro -->
        <div class="section-margin text-center">
            <div class="container">
                <h3 class="title text-upper mb-30">All Type Parts Scanning</h3>
                <p class="max-w750">
                    Capture every detail with <strong>Zeno 3D’s advanced parts scanning solutions</strong>. 
                    From small precision components to large industrial assemblies, we provide 
                    <strong>high-resolution 3D scans</strong> that accurately capture all geometries and surface details. 
                    Our scanning process ensures reliable and detailed digital models suitable for reverse engineering, 
                    quality inspection, prototyping, and production planning. By detecting flaws, wear, or deviations early, 
                    we help manufacturers save time, reduce errors, and improve overall product quality.
                </p>
            </div>
        </div>

        <!-- Features Gallery -->
        <div class="container p-relative section-margin over-hidden">
            <h4 class="title text-upper mb-30">Core Features of Parts Scanning</h4>
            <div class="gallery-portfolio">

                <!-- Precision Scanning -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/All-Type-Parts-Scanning2.jpg"
                    data-fancybox="_1" data-caption="High-Resolution Precision Scanning">
                    <img src="assets/img/Zeno_All_img/All-Type-Parts-Scanning2.jpg" alt="Precision Scanning">
                    <div class="cap">
                        <span>Precision Scanning</span>
                    </div>
                </a>

                <!-- Small to Large Components -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3D Inspection.jpg"
                    data-fancybox="_1" data-caption="Scanning from Small Parts to Large Assemblies">
                    <img src="assets/img/Zeno_All_img/3D Inspection.jpg" alt="Small to Large Components">
                    <div class="cap">
                        <span>Small to Large Components</span>
                    </div>
                </a>

                <!-- Accurate CAD Conversion -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/Reverse Engineering.jpg"
                    data-fancybox="_1" data-caption="Accurate CAD Conversion from Scanned Data">
                    <img src="assets/img/Zeno_All_img/Reverse Engineering.jpg" alt="CAD Conversion">
                    <div class="cap">
                        <span>Accurate CAD Conversion</span>
                    </div>
                </a>

                <!-- Industry Applications -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/3D Printing_s_P.jpg"
                    data-fancybox="_1" data-caption="Applications in Automotive | Aerospace | Tooling | Medical">
                    <img src="assets/img/Zeno_All_img/3D Printing_s_P.jpg" alt="Industry Applications">
                    <div class="cap">
                        <span>Industry Applications</span>
                    </div>
                </a>

            </div>
        </div>

        <!-- Benefits Section -->
        <div class="section-margin text-center">
            <div class="container">
                <h4 class="title text-upper mb-50">Key Benefits of Our Parts Scanning Services</h4>
                <div class="benefits-grid">

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-microchip"></i></div>
                        <h5>High-Resolution Scans</h5>
                        <p>
                            Our ultra-precise 3D scans capture even the most intricate geometries of both simple and complex parts. 
                            With accuracy up to ±0.01 mm, every detail is digitally preserved for analysis, design validation, and manufacturing applications.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-cubes"></i></div>
                        <h5>Supports All Sizes</h5>
                        <p>
                            From tiny precision components to large industrial assemblies, our scanning technology adapts seamlessly. 
                            Every part, regardless of size or shape, is accurately digitized, ensuring consistency across all components.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-drafting-compass"></i></div>
                        <h5>Seamless CAD Integration</h5>
                        <p>
                            Scanned data is immediately compatible with CAD software, 3D printing, and manufacturing workflows. 
                            This enables faster product development, precise prototyping, and effortless integration into design and production pipelines.
                        </p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-shield-alt"></i></div>
                        <h5>Improved Quality Control</h5>
                        <p>
                            Reliable and accurate digital models support rigorous inspection, deviation analysis, and error reduction. 
                            Manufacturers can detect defects early, optimize assembly fits, and maintain the highest standards of product quality.
                        </p>
                    </div>

                </div>
            </div>
        </div>

        <!-- Detailed Info / Project Info -->
        <div class="project-info section-margin">
            <div class="container">
                <div class="section-title dsn-fill mb-70 d-flex flex-column">
                    <span class="sub-heading mb-5">Our Service</span>
                    <h2 class="title">All Type Parts Scanning <br> Precision Capture for Every Component</h2>
                </div>

                <p>
                    At <strong>Zeno 3D</strong>, our <strong>All Type Parts Scanning</strong> services deliver a complete and versatile solution for digitizing parts of every size, material, and complexity. 
                    By using advanced 3D scanning technologies, we generate highly accurate digital representations of your physical components. 
                    These digital models are ideal for reverse engineering, inspection, prototyping, and direct integration into production workflows.
                </p>

                <p>
                    Our scanning solutions are trusted across multiple industries including <strong>automotive, aerospace, medical, industrial manufacturing, and tooling</strong>. 
                    By eliminating manual measurement errors and capturing even the finest details, Zeno 3D ensures reliable and actionable data, saving both time and cost during product development, quality assurance, and manufacturing processes.
                </p>

                <p>
                    Whether you are working on legacy parts, custom equipment, or precision assemblies, our services offer <strong>fast turnaround, exceptional accuracy, and seamless CAD integration</strong>. 
                    This enables engineers and designers to accelerate prototyping, validate designs, and optimize manufacturing processes efficiently.
                </p>

                <p>
                    With Zeno 3D’s parts scanning, companies gain the confidence of working with accurate digital twins of their components. 
                    These digital assets can be reused for iterative design improvements, predictive maintenance, and advanced simulations, helping businesses achieve higher product reliability and innovation potential.
                </p>

            </div>
        </div>

    </div>

</div>
<?php include 'footer.php'; ?>

<!-- ===== CSS ===== -->
<style>
.benefits-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 35px;
    margin-top: 40px;
}
.benefit-card {
    background: #fff;
    border-radius: 16px;
    padding: 35px 25px;
    text-align: center;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: transform 0.35s ease, box-shadow 0.35s ease;
    position: relative;
    overflow: hidden;
    cursor: pointer;
}
.benefit-card:hover {transform: translateY(-12px);box-shadow:0 18px 45px rgba(0,0,0,0.2);}
.benefit-card .icon {width:70px;height:70px;border-radius:50%;background:linear-gradient(135deg,#007BFF,#00A86B);display:flex;align-items:center;justify-content:center;margin:0 auto 18px;font-size:30px;color:#fff;transition:transform 0.35s ease, box-shadow 0.35s ease, background 0.35s ease;}
.benefit-card:hover .icon {transform: scale(1.25) rotate(10deg);box-shadow:0 8px 20px rgba(0,171,85,0.5);background:linear-gradient(135deg,#00A86B,#007BFF);}
.benefit-card h5 {font-size:20px;font-weight:700;color:#222;margin-bottom:12px;}
.benefit-card p {font-size:15px;color:#666;line-height:1.7;}
.benefit-card::after {content:"";position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(0,171,85,0.05);border-radius:16px;opacity:0;transition:opacity 0.35s ease;}
.benefit-card:hover::after {opacity:1;}
</style>
