<?php include 'header.php'; ?>
<div id="dsn-scrollbar">

    <!-- ========== Reverse Engineering Section ========== -->
    <div id="page_wrapper" class="wrapper">
    
        <!-- Service Intro -->
        <div class="section-margin text-center">
            <div class="container">
                <h3 class="title text-upper mb-30">Reverse Engineering</h3>
                <p class="max-w750">
                    Recreate, optimize, and innovate with <strong>Zeno 3D’s Reverse Engineering solutions</strong>. 
                    From legacy parts without drawings to complex components, we capture precise 3D data 
                    and convert it into accurate CAD models ready for manufacturing. Our team ensures every part, 
                    whether a simple component or intricate assembly, is analyzed for geometry, tolerance, and functionality, 
                    giving you full confidence in the final digital model.
                </p>
            </div>
        </div>

        <!-- Features Gallery -->
        <div class="container p-relative section-margin over-hidden">
            <h4 class="title text-upper mb-30">Core Features of Reverse Engineering</h4>
            <div class="gallery-portfolio">

                <!-- Legacy Part Conversion -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/reverse_engineering/Legacy Part to CAD Conversion.jpg"
                    data-fancybox="_1" data-caption="Legacy Part to CAD Conversion">
                    <img src="assets/img/Zeno_All_img/reverse_engineering/Legacy Part to CAD Conversion.jpg" alt="Legacy Part to CAD Conversion">
                    <div class="cap">
                        <span>Legacy Part to CAD Conversion</span>
                    </div>
                </a>

                <!-- Complex Geometry Capture -->
                <!-- <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/reverse_engineering/"
                    data-fancybox="_1" data-caption="Complex Geometry Scanning">
                    <img src="assets/img/Zeno_All_img/3D Inspection.jpg" alt="Complex Geometry Scanning">
                    <div class="cap">
                        <span>Complex Geometry Scanning</span>
                    </div>
                </a> -->

                  
                <!-- Accurate CAD Modeling -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/reverse_engineering/High-Precision CAD Modeling.jpg"
                    data-fancybox="_1" data-caption="High-Precision CAD Modeling">
                    <img src="assets/img/Zeno_All_img/reverse_engineering/High-Precision CAD Modeling.jpg" alt="High-Precision CAD Modeling">
                    <div class="cap">
                        <span>High-Precision CAD Modeling</span>
                    </div>
                </a>


                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/Reverse Engineering.jpg" data-fancybox="_1" data-caption="Accurate CAD Conversion from Scanned Data" style="position: absolute; transform: translateX(0px) translateY(480.288px) translateZ(0px); width: 345px;">
                    <img src="assets/img/Zeno_All_img/Reverse Engineering.jpg" alt="CAD Conversion">
                    <div class="cap">
                        <span>Accurate CAD Conversion</span>
                    </div>
                </a>

                <!-- Industry Applications -->
                <a class="link-pop fj-gallery-item" href="assets/img/Zeno_All_img/reverse_engineering/Applications Across Industries.jpg"
                    data-fancybox="_1" data-caption="Applications in Automotive, Aerospace, Tooling, and Industrial">
                    <img src="assets/img/Zeno_All_img/reverse_engineering/Applications Across Industries.jpg" alt="Applications Across Industries">
                    <div class="cap">
                        <span>Applications Across Industries</span>
                    </div>
                </a>

            </div>
        </div>

        <!-- Benefits Section -->
        <div class="section-margin text-center">
            <div class="container">
                <h4 class="title text-upper mb-50">Why Choose Zeno 3D for Reverse Engineering?</h4>
                <div class="benefits-grid">

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-cogs"></i></div>
                        <h5>Accurate CAD Conversion</h5>
                        <p>Transform physical parts into precise digital CAD models, ready for manufacturing, prototyping, and design improvements. 
                        Every curve, hole, and feature is faithfully captured to maintain engineering integrity.</p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-industry"></i></div>
                        <h5>Support for Complex Components</h5>
                        <p>Handle legacy, discontinued, or highly complex components with ease. 
                        Our expert team can reverse engineer intricate assemblies while preserving functionality and tolerances.</p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-rocket"></i></div>
                        <h5>Rapid Prototyping</h5>
                        <p>Quickly produce production-ready prototypes or replacement parts. 
                        Reduce design iteration time and accelerate product development cycles with fast and accurate digital models.</p>
                    </div>

                    <div class="benefit-card">
                        <div class="icon"><i class="fas fa-check-square"></i></div>
                        <h5>Precision Inspection</h5>
                        <p>Ensure every part meets specifications through detailed inspection. 
                        Capture deviations, validate dimensions, and provide quality assurance data for reliable manufacturing outcomes.</p>
                    </div>

                </div>
            </div>
        </div>

        <!-- Detailed Info / Project Info -->
        <div class="project-info section-margin">
            <div class="container">
                <div class="section-title dsn-fill mb-70 d-flex flex-column">
                    <span class="sub-heading mb-5">Our Service</span>
                    <h2 class="title">Reverse Engineering <br> Precision Solutions</h2>
                </div>

                <p>
                    At Zeno 3D, our <strong>Reverse Engineering</strong> services allow you to recreate legacy
                    or complex parts with high accuracy. Using advanced 3D scanning and CAD conversion techniques, 
                    we capture every detail of your physical component, including intricate geometries, hidden features, and surface finishes. 
                    Our experts then transform this data into precise, production-ready digital CAD models, enabling seamless integration 
                    with manufacturing, prototyping, or inspection workflows. This ensures your final product is reliable and meets industry standards.
                </p>

                <p>
                    Whether you're dealing with <strong>industrial machinery, automotive components, custom tools, or precision equipment</strong>, 
                    our team ensures that every model adheres to exacting tolerances. By combining detailed scanning, careful modeling, and 
                    rigorous validation, we provide solutions that minimize errors, reduce lead times, and support the development of reliable 
                    replacement parts or upgrades for legacy systems. Our approach also allows for iterative improvements and design optimization.
                </p>

                <p>
                    Additionally, Zeno 3D offers comprehensive documentation and reporting for each reverse engineered part. 
                    This includes dimensional analysis, material considerations, functional recommendations, and suggested improvements for enhanced performance. 
                    Our fast turnaround, expert guidance, and detailed reports make us a trusted partner for companies seeking high-quality, 
                    efficient, and reliable reverse engineering services that fit seamlessly into their workflows.
                </p>
            </div>
        </div>

    </div>

</div>
<?php include 'footer.php'; ?>

<!-- ===== CSS ===== -->
<style>
.benefits-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 35px;
    margin-top: 40px;
}
.benefit-card {
    background: #fff;
    border-radius: 16px;
    padding: 35px 25px;
    text-align: center;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: transform 0.35s ease, box-shadow 0.35s ease;
    position: relative;
    overflow: hidden;
    cursor: pointer;
}
.benefit-card:hover {transform: translateY(-12px);box-shadow:0 18px 45px rgba(0,0,0,0.2);}
.benefit-card .icon {width:70px;height:70px;border-radius:50%;background:linear-gradient(135deg,#007BFF,#00A86B);display:flex;align-items:center;justify-content:center;margin:0 auto 18px;font-size:30px;color:#fff;transition:transform 0.35s ease, box-shadow 0.35s ease, background 0.35s ease;}
.benefit-card:hover .icon {transform: scale(1.25) rotate(10deg);box-shadow:0 8px 20px rgba(0,171,85,0.5);background:linear-gradient(135deg,#00A86B,#007BFF);}
.benefit-card h5 {font-size:20px;font-weight:700;color:#222;margin-bottom:12px;}
.benefit-card p {font-size:15px;color:#666;line-height:1.7;}
.benefit-card::after {content:"";position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(0,171,85,0.05);border-radius:16px;opacity:0;transition:opacity 0.35s ease;}
.benefit-card:hover::after {opacity:1;}
</style>
